#ifndef _USB_CONFIG_H
#define _USB_CONFIG_H

//Defines the number of endpoints for this device. (Always add one for EP0). For two EPs, this should be 3.
#define ENDPOINTS 3

//#define SOP8
#define QFN20

#ifdef SOP8
#define USB_PIN_DP 2
#define USB_PIN_DM 1
//#define USB_PIN_DPU 4 
#define USB_PORT A
#else
#ifdef QFN20
#define USB_PIN_DP 2
#define USB_PIN_DM 1
//#define USB_PIN_DPU 5
#define USB_PORT A
#else
#error "NO FORMAT DEFINED, please specify one in usb_config.h"
#endif
#endif

#define RV003USB_OPTIMIZE_FLASH    0
#define RV003USB_HANDLE_IN_REQUEST 1
#define RV003USB_OTHER_CONTROL	   1
#define RV003USB_HANDLE_USER_DATA  1
#define RV003USB_HID_FEATURES	   0
#define RV003USB_EVENT_DEBUGGING   0

#ifndef __ASSEMBLER__

#include <tusb_types.h>
//#include <cdc.h>
//#define INSTANCE_DESCRIPTORS
#ifdef INSTANCE_DESCRIPTORS

static const uint8_t device_descriptor[] = {
	18, //Length
	TUSB_DESC_DEVICE,  //Type (Device)
	0x10, 0x01, //Spec
	TUSB_CLASS_VENDOR_SPECIFIC, //Device Class
	MISC_SUBCLASS_COMMON, //Subclass
	0x00, //Device Protocol
	0x08, //Max packet size for EP0 (This has to be 8 because of the USB Low-Speed Standard)
	0x48, 0x43, //ID Vendor
	0x37, 0x55, //ID Product
	0x10, 0x01, //ID Rev
	1, //Manufacturer string
	2, //Product string
	3, //Serial string
	1, //Max number of configurations
};

static const uint8_t config_descriptor[] = {
	// configuration descriptor, USB spec 9.6.3, page 264-266, Table 9-10

	9,					  // bLength;
	TUSB_DESC_CONFIGURATION,  // bDescriptorType;
	32, 0x00,				  // wTotalLength
	0x01,					  // bNumInterfaces (Normally 1)
	0x01,					  // bConfigurationValue
	0x00,					  // iConfiguration
	0x80,					  // bmAttributes (was 0xa0)
	0x64,					  // bMaxPower (200mA)

	9,						  // bLength
	TUSB_DESC_INTERFACE,	  // bDescriptorType
	0,						  // bInterfaceNumber
	0,						  // bAlternateSetting
	2,						  // bNumEndpoints
	TUSB_CLASS_VENDOR_SPECIFIC, 	// bInterfaceClass
	0,  // bInterfaceSubClass
	0,    		   // bInterfaceProtocol
	0x00,		  // iInterface (For getting the other descriptor)

	7,		  // endpoint descriptor (For endpoint 1)
	TUSB_DESC_ENDPOINT,   // Endpoint Descriptor
	USB_DIR_IN +1,	      // Endpoint Address
	TUSB_XFER_BULK,		  // Attributes
	0x08,	0x00,		  // Size
	0,			  // Interval

	7,			  // endpoint descriptor (For endpoint 1)
	TUSB_DESC_ENDPOINT,   // Endpoint Descriptor
	USB_DIR_OUT +1,		  // Endpoint Address
	TUSB_XFER_BULK,		  // Attributes
	0x08,	0x00, // Size
	0,			  // Interval

};

#define STR_MANUFACTURER u"ch32"
#define STR_PRODUCT 	 u"usb gpio"
#define STR_SERIAL	 u"0314"

struct usb_string_descriptor_struct {
	uint8_t bLength;
	uint8_t bDescriptorType;
	uint16_t wString[];
};
const static struct usb_string_descriptor_struct string0 __attribute__((section(".rodata"))) = {
	4,
	TUSB_DESC_STRING,
	{0x0409}
};
const static struct usb_string_descriptor_struct string1 __attribute__((section(".rodata")))  = {
	sizeof(STR_MANUFACTURER),
	TUSB_DESC_STRING,
	STR_MANUFACTURER
};
const static struct usb_string_descriptor_struct string2 __attribute__((section(".rodata")))  = {
	sizeof(STR_PRODUCT),
	TUSB_DESC_STRING,
	STR_PRODUCT
};
const static struct usb_string_descriptor_struct string3 __attribute__((section(".rodata")))  = {
	sizeof(STR_SERIAL),
	TUSB_DESC_STRING,
	STR_SERIAL
};



// This table defines which descriptor data is sent for each specific
// request from the host (in wValue and wIndex).
const static struct descriptor_list_struct {
	uint32_t	lIndexValue;
	const uint8_t	*addr;
	uint8_t		length;
} descriptor_list[] = {
	{0x00000100, device_descriptor, sizeof(device_descriptor)},
	{0x00000200, config_descriptor, sizeof(config_descriptor)},

	{0x00000300, (const uint8_t *)&string0, 4},
	{0x04090301, (const uint8_t *)&string1, sizeof(STR_MANUFACTURER)},
	{0x04090302, (const uint8_t *)&string2, sizeof(STR_PRODUCT)},	
	{0x04090303, (const uint8_t *)&string3, sizeof(STR_SERIAL)}
};
#define DESCRIPTOR_LIST_ENTRIES ((sizeof(descriptor_list))/(sizeof(struct descriptor_list_struct)) )

#endif // INSTANCE_DESCRIPTORS

#endif

#endif 
